import { notFound } from "next/navigation";
import { cmsFetch } from "@/lib/cms";

// NOTE: In static export, dynamic routes require pre-generation.
// We'll generate paths via generateStaticParams using CMS slugs.

export async function generateStaticParams() {
  // Minimal approach: pre-generate 'home' only by default.
  // You can expand later by adding an endpoint /api/pages-slugs (optional).
  return [{ slug: "home" }];
}

function renderBlocks(blocks: any) {
  let arr: any[] = [];
  try {
    arr = Array.isArray(blocks) ? blocks : JSON.parse(blocks || "[]");
  } catch {
    arr = [];
  }

  return arr.map((b, i) => {
    if (b.type === "hero") {
      return (
        <section key={i} style={{ padding: 24, border: "1px solid #eee", borderRadius: 16, marginBottom: 16 }}>
          <h2 style={{ marginTop: 0 }}>{b.title}</h2>
          {b.subtitle && <p>{b.subtitle}</p>}
          {b.cta?.href && <a href={b.cta.href}>{b.cta.label || "Learn more"}</a>}
        </section>
      );
    }
    if (b.type === "text") {
      return (
        <section key={i} style={{ padding: 24, border: "1px solid #eee", borderRadius: 16, marginBottom: 16 }}>
          <div dangerouslySetInnerHTML={{ __html: b.html || "" }} />
        </section>
      );
    }
    return null;
  });
}

export default async function CMSPage({ params }: { params: { slug: string } }) {
  const data = await cmsFetch(`/api/pages/${params.slug}`);
  if (!data) return notFound();

  return (
    <main style={{ padding: 24, maxWidth: 900, margin: "0 auto" }}>
      <h1 style={{ marginTop: 0 }}>{data.title}</h1>
      {renderBlocks(data.blocks)}
    </main>
  );
}
